/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Customizing;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ProgressMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class SplashScreen
implements ProgressMonitor,
Runnable {
    private Mode mode;
    private Display display;
    private Shell shell;
    private ProgressBar bar;
    private Label label;
    private Label textLabel;
    private String text;
    private int percentComplete = 0;
    private boolean closed = false;
    private boolean disposeDisplay = false;

    public SplashScreen(Mode mode, boolean disposeDisplay) {
        if (mode == null) {
            mode = Mode.Startup;
        }
        Logger.debug((String)("init splash screen: " + mode));
        this.mode = mode;
        this.disposeDisplay = disposeDisplay;
        this.display = GUI.getDisplay();
        this.shell = new Shell(this.display, 0);
        String icon = Customizing.SETTINGS.getString("application.icon", null);
        if (icon != null) {
            this.shell.setImage(SWTUtil.getImage(icon));
        } else {
            this.shell.setImages(new Image[]{SWTUtil.getImage("hibiscus-icon-64x64.png"), SWTUtil.getImage("hibiscus-icon-128x128.png"), SWTUtil.getImage("hibiscus-icon-256x256.png")});
        }
        this.shell.setAlpha(Customizing.SETTINGS.getInt("application.splashscreen.alpha", 255));
        String name = Application.getI18n().tr(Customizing.SETTINGS.getString("application.name", "Jameica {0}"), Application.getManifest().getVersion().toString());
        this.shell.setText(name);
        this.shell.setBackground(new Color((Device)this.display, 0, 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String randomSplash() {
        ZipFile jar = null;
        try {
            File f = new File("lib/splash.jar");
            if (!(f.exists() && f.isFile() && f.canRead())) {
                Logger.warn((String)(f.getCanonicalPath() + " not found or not readable, skipping random splashscreen"));
                String string = null;
                return string;
            }
            jar = new JarFile(f);
            ArrayList<CallSite> names = new ArrayList<CallSite>();
            Enumeration<JarEntry> entries = ((JarFile)jar).entries();
            while (entries.hasMoreElements()) {
                String s;
                JarEntry e = entries.nextElement();
                if (e.getSize() <= 0L || e.isDirectory() || !(s = e.getName().toLowerCase()).toLowerCase().endsWith(".jpg") && !s.toLowerCase().endsWith(".png")) continue;
                names.add((CallSite)((Object)("/" + e.getName())));
            }
            String name = (String)names.get(new Random().nextInt(names.size()));
            Logger.debug((String)("using random splashscreen " + name));
            String string = name;
            return string;
        }
        catch (Exception e) {
            Logger.error((String)"unable to get splash", (Throwable)e);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to close jar file", (Throwable)e);
                }
            }
        }
        return null;
    }

    public synchronized void init() {
        this.display.syncExec((Runnable)this);
    }

    @Override
    public void run() {
        Logger.debug((String)"starting splash screen thread");
        GridLayout l = new GridLayout(1, false);
        l.marginWidth = 0;
        l.marginHeight = 0;
        l.horizontalSpacing = 0;
        l.verticalSpacing = 0;
        this.shell.setLayout((Layout)l);
        String s = null;
        if (Customizing.SETTINGS.getBoolean("application.splashscreen.random", false)) {
            s = this.randomSplash();
        }
        if (s == null) {
            s = Customizing.SETTINGS.getString(this.mode.param, this.mode.image);
        }
        Image image = null;
        try {
            File f;
            InputStream is = this.shell.getClass().getResourceAsStream(s);
            if (is == null && (f = new File(s)).exists() && f.isFile() && f.canRead()) {
                is = new FileInputStream(f);
            }
            if (is != null) {
                image = new Image((Device)this.display, is);
            }
        }
        catch (Exception e) {
            Logger.write((Level)Level.INFO, (String)("unable to load custom splashscreen: " + s), (Throwable)e);
        }
        if (image == null) {
            image = SWTUtil.getImage(s);
        }
        this.label = new Label((Composite)this.shell, 0);
        this.label.setImage(image);
        this.label.setLayoutData((Object)new GridData(256));
        this.label.setBackground(new Color((Device)this.display, 0, 0, 0));
        this.textLabel = new Label((Composite)this.shell, 0);
        this.textLabel.setForeground(new Color((Device)this.display, 255, 255, 255));
        this.textLabel.setBackground(new Color((Device)this.display, 0, 0, 0));
        this.textLabel.setText(this.text == null ? "" : this.text);
        this.textLabel.setLayoutData((Object)new GridData(256));
        this.bar = new ProgressBar((Composite)this.shell, 65536);
        this.bar.setMaximum(100);
        this.bar.setBackground(new Color((Device)this.display, 255, 255, 255));
        GridData barGd = new GridData(256);
        barGd.verticalIndent = 0;
        this.bar.setLayoutData((Object)barGd);
        Rectangle size = image.getBounds();
        this.shell.setSize(size.width + 2, size.height + 36);
        Rectangle splashRect = this.shell.getBounds();
        Rectangle displayRect = this.display.getPrimaryMonitor().getBounds();
        int x = displayRect.x + (displayRect.width - splashRect.width) / 2;
        int y = displayRect.y + (displayRect.height - splashRect.height) / 2;
        this.shell.setLocation(x, y);
        this.shell.open();
        this.display.readAndDispatch();
        this.label.redraw();
        this.label.update();
    }

    public void setPercentComplete(int percent) {
        if (Application.inServerMode() || this.closed || percent < this.percentComplete || this.display == null || this.display.isDisposed()) {
            return;
        }
        if (percent > 100) {
            percent = 100;
        }
        if (percent < 0) {
            percent = 0;
        }
        this.percentComplete = percent;
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (SplashScreen.this.bar == null || SplashScreen.this.bar.isDisposed() || SplashScreen.this.display == null || SplashScreen.this.display.isDisposed()) {
                    return;
                }
                try {
                    Logger.trace((String)("startup completed: " + SplashScreen.this.percentComplete + " %"));
                    SplashScreen.this.bar.setSelection(SplashScreen.this.percentComplete);
                    SplashScreen.this.bar.update();
                    SplashScreen.this.display.readAndDispatch();
                }
                catch (SWTException e) {
                    Logger.debug((String)"display already disposed");
                }
            }
        });
    }

    public void setStatus(int status) {
        if (this.closed || Application.inServerMode()) {
            return;
        }
        if (status == 0) {
            this.closed = true;
        }
        if (status == 0 && this.display != null && !this.display.isDisposed()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Logger.info((String)"stopping splash screen");
                    try {
                        SplashScreen.this.shell.dispose();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (SplashScreen.this.disposeDisplay) {
                        try {
                            SplashScreen.this.display.dispose();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    public void setStatusText(final String text) {
        if (text == null) {
            return;
        }
        this.text = text;
        if (Application.inServerMode() || this.closed) {
            return;
        }
        if (this.display != null && !this.display.isDisposed()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (SplashScreen.this.textLabel == null || SplashScreen.this.textLabel.isDisposed() || SplashScreen.this.display == null || SplashScreen.this.display.isDisposed()) {
                        return;
                    }
                    String s = " " + text + " ...";
                    Logger.info((String)s);
                    SplashScreen.this.textLabel.setText(s);
                    SplashScreen.this.textLabel.update();
                    SplashScreen.this.display.readAndDispatch();
                }
            });
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    public void log(String msg) {
    }

    public void addPercentComplete(int percent) {
        if (percent < 1) {
            return;
        }
        this.setPercentComplete(this.getPercentComplete() + percent);
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public static enum Mode {
        Startup("application.splashscreen.startup", "splash.png"),
        Shutdown("application.splashscreen.shutdown", "shutdown.png");

        private String param = null;
        private String image = null;

        private Mode(String param, String image) {
            this.param = param;
            this.image = image;
        }
    }
}

